/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.portal.service.impl;

import com.tp_link.eap.configuration.Configuration;
import com.tp_link.eap.device.EventType;
import com.tp_link.eap.domain.cloud.CloudUser;
import com.tp_link.eap.domain.eap.Ap;
import com.tp_link.eap.domain.eap.Client;
import com.tp_link.eap.domain.eap.bean.SsidOverride;
import com.tp_link.eap.domain.global.OperationResult;
import com.tp_link.eap.domain.globalsetting.PortalSetting;
import com.tp_link.eap.domain.globalsetting.Ssid;
import com.tp_link.eap.domain.hotspot.LocalUser;
import com.tp_link.eap.domain.hotspot.Voucher;
import com.tp_link.eap.domain.message.body.AuthorizationBody;
import com.tp_link.eap.domain.portal.AuthedUser;
import com.tp_link.eap.domain.portal.Guest;
import com.tp_link.eap.domain.portal.StatCurrentGuest;
import com.tp_link.eap.domain.ui.Grid;
import com.tp_link.eap.domain.ui.QueryData;
import com.tp_link.eap.domain.ui.QueryFilter;
import com.tp_link.eap.domain.ui.QueryPage;
import com.tp_link.eap.domain.ui.QuerySort;
import com.tp_link.eap.monitor.globalsetting.repo.SsidRepository;
import com.tp_link.eap.monitor.globalsetting.service.l;
import com.tp_link.eap.monitor.hotspot.repo.LocalUserRepository;
import com.tp_link.eap.monitor.hotspot.repo.VoucherRepository;
import com.tp_link.eap.monitor.monitor.a.c;
import com.tp_link.eap.monitor.monitor.a.e;
import com.tp_link.eap.monitor.portal.repo.GuestRepository;
import com.tp_link.eap.monitor.portal.service.b;
import com.tp_link.eap.monitor.portal.service.d;
import com.tp_link.eap.monitor.portal.service.impl.a;
import com.tp_link.eap.multicontrol.ControlType;
import com.tp_link.eap.multicontrol.OperationResponse;
import com.tp_link.eap.multicontrol.ResErrorCode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.sf.json.JSONObject;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="guestService")
public class GuestService
extends com.tp_link.eap.i.a.a<Guest>
implements b {
    @Autowired
    private GuestRepository a;
    @Autowired
    private LocalUserRepository b;
    @Autowired
    private VoucherRepository c;
    @Autowired
    private MongoTemplate d;
    @Autowired
    private com.tp_link.eap.monitor.monitor.service.b e;
    @Autowired
    private com.tp_link.eap.monitor.globalsetting.service.d f;
    @Autowired
    private l g;
    @Autowired
    private d h;
    @Autowired
    private com.tp_link.eap.monitor.monitor.service.d i;
    @Autowired
    private com.tp_link.eap.monitor.globalsetting.service.b j;
    @Autowired
    private SsidRepository k;
    @Autowired
    private com.tp_link.eap.monitor.cloud.clouduser.service.a l;
    private static final Configuration m = com.tp_link.eap.configuration.a.a((String)"netty.properties");
    private static final int n = Integer.parseInt(m.getProperty("portal.sender.thread.num"));
    private static final ExecutorService o = Executors.newFixedThreadPool(n);
    private final Logger p = LoggerFactory.getLogger(this.getClass());
    private static final c q = com.tp_link.eap.monitor.monitor.a.e.b();
    private Long r = 86400L;
    private static final Long s = 2592000L;

    @Override
    public Guest findById(String id) {
        if (id == null) {
            return null;
        }
        return (Guest)this.a.findOne((Serializable)((Object)id));
    }

    @Override
    public List<Guest> getGuestList(Integer authType, String clientMac) {
        if (authType < 0 || clientMac == null) {
            return new ArrayList<Guest>();
        }
        String string = com.tp_link.eap.d.b.a();
        return this.a.findBySiteAndAuthTypeAndClientMac(string, authType, clientMac);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse addGuestInfo(Guest guest, String apMac) {
        JSONObject jSONObject;
        JSONObject jSONObject2;
        String string = com.tp_link.eap.d.b.a();
        if (string == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"site").is((Object)string));
        query.addCriteria(Criteria.where((String)"clientMac").is((Object)guest.getClientMac()));
        query.addCriteria(Criteria.where((String)"ssidId").is((Object)guest.getSsidId()));
        query.addCriteria(Criteria.where((String)"apMac").is((Object)guest.getApMac()));
        query.addCriteria(Criteria.where((String)"ssidName").is((Object)guest.getSsidName()));
        Voucher voucher = guest.getVoucher();
        LocalUser localUser = guest.getLocalUser();
        if (voucher != null && voucher.getType() == 1) {
            query.addCriteria(Criteria.where((String)"voucherCode").is((Object)voucher.getCode()));
            jSONObject = jSONObject2 = com.tp_link.eap.b.b.a.g((String)"guestglobal");
            synchronized (jSONObject) {
                Guest guest2 = (Guest)this.d.findOne(query, Guest.class);
                if (guest2 != null) {
                    guest.setId(guest2.getId());
                    guest.setUpload(guest2.getUpload());
                    guest.setDownload(guest2.getDownload());
                    guest.setDuration(guest2.getDuration());
                    guest.setUploadTotal(guest2.getUploadTotal());
                    guest.setDownloadTotal(guest2.getDownloadTotal());
                    if (guest2.getVoucher().getByteQuotaEnable().booleanValue() && guest2.getUploadTotal() + guest2.getDownloadTotal() > guest2.getVoucher().getByteQuota() * 0x100000L) {
                        return new OperationResponse(ResErrorCode.bO);
                    }
                }
                guest.setIsValid(Boolean.valueOf(true));
                this.a.save(guest);
            }
        }
        if (localUser != null && com.tp_link.eap.util.e.dT.equals(localUser.getMacType())) {
            query.addCriteria(Criteria.where((String)"localUserId").is((Object)localUser.getId()));
            jSONObject = jSONObject2 = com.tp_link.eap.b.b.a.g((String)"guestglobal");
            synchronized (jSONObject) {
                Guest guest3 = (Guest)this.d.findOne(query, Guest.class);
                if (guest3 != null) {
                    guest.setId(guest3.getId());
                    guest.setUpload(guest3.getUpload());
                    guest.setDownload(guest3.getDownload());
                    guest.setDuration(guest3.getDuration());
                    guest.setUploadTotal(guest3.getUploadTotal());
                    guest.setDownloadTotal(guest3.getDownloadTotal());
                    if (guest3.getLocalUser().getQuotaEnable() && guest3.getUploadTotal() + guest3.getDownloadTotal() > guest3.getLocalUser().getQuotaLimit() * 0x100000L) {
                        return new OperationResponse(ResErrorCode.bS);
                    }
                }
                guest.setIsValid(Boolean.valueOf(true));
                this.a.save(guest);
            }
        }
        query.addCriteria(Criteria.where((String)"isValid").is((Object)guest.getIsValid()));
        jSONObject = jSONObject2 = com.tp_link.eap.b.b.a.g((String)"guestglobal");
        synchronized (jSONObject) {
            if (this.d.exists(query, Guest.class)) {
                this.p.debug("AUTHORIZATION already existed");
                return new OperationResponse(ResErrorCode.bT);
            }
            this.a.save(guest);
        }
        this.a(guest);
        jSONObject2 = new ArrayList();
        jSONObject2.add(guest);
        this.sendAuthInfo((List<Guest>)jSONObject2, apMac);
        jSONObject = new JSONObject();
        jSONObject.put((Object)"guestId", (Object)guest.getId());
        return new OperationResponse(ResErrorCode.a, "success", (Object)jSONObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Guest a(String string, String string2, Integer n2, String string3, String string4) {
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"site").is((Object)string));
        query.addCriteria(Criteria.where((String)"clientMac").is((Object)string2));
        query.addCriteria(Criteria.where((String)"ssidId").is((Object)n2));
        query.addCriteria(Criteria.where((String)"isValid").is((Object)true));
        query.addCriteria(Criteria.where((String)"apMac").is((Object)string4));
        query.addCriteria(Criteria.where((String)"ssidName").is((Object)string3));
        Guest guest = (Guest)this.d.findOne(query, Guest.class);
        if (guest == null) {
            return null;
        }
        Long l2 = System.currentTimeMillis() / 1000L;
        if (guest.getEnd() < l2) {
            Object object;
            guest.setIsValid(Boolean.valueOf(false));
            Object object2 = object = com.tp_link.eap.b.b.a.g((String)"guestglobal");
            synchronized (object2) {
                this.a.save(guest);
            }
            return null;
        }
        return guest;
    }

    @Override
    public Guest getAuthInfoByRadioId(String site, String clientMac, Integer radioId, String ssidName, String apMac) {
        boolean bl = false;
        Integer n2 = this.a(false, ssidName, radioId, apMac);
        this.p.debug("ssidId is {}", (Object)n2);
        if (n2 <= 0) {
            n2 = this.a(true, ssidName, radioId, apMac);
            bl = true;
            this.p.debug("override ssidId is {}", (Object)n2);
        }
        if (n2 <= 0) {
            return null;
        }
        return this.a(site, clientMac, n2, ssidName, bl ? apMac : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unAuthorize(String guestId) {
        Object object;
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"_id").is((Object)guestId));
        Update update = new Update();
        update.set("isValid", (Object)false);
        Object object2 = object = com.tp_link.eap.b.b.a.g((String)"guestglobal");
        synchronized (object2) {
            Guest guest = (Guest)this.d.findAndModify(query, update, Guest.class);
            if (guest == null) {
                this.p.debug("findAndModify fail.");
                return false;
            }
            this.p.debug("findAndModify success.");
            if (guest.getAuthType() == 7) {
                this.j.deleteAuthingDataByClientMacAndSite(guest.getClientMac(), guest.getSite());
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse unAuthorize(Client c2) {
        String string = com.tp_link.eap.d.b.a();
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            this.p.error("Failed to get site in thread");
            return new OperationResponse(ResErrorCode.l);
        }
        if (c2 == null) {
            this.p.debug("unAuth client is null.");
            return new OperationResponse(ResErrorCode.d);
        }
        String string2 = c2.getMac();
        Guest guest = this.getAuthInfoByRadioId(string, string2, c2.getRadioId(), c2.getSsid(), c2.getApMac());
        if (guest != null) {
            Object object;
            Object object2 = object = com.tp_link.eap.b.b.a.g((String)"guestglobal");
            synchronized (object2) {
                guest = (Guest)this.a.findOne((Serializable)((Object)guest.getId()));
                guest.setIsValid(Boolean.valueOf(false));
                guest.setEnd(Long.valueOf(System.currentTimeMillis() / 1000L));
                this.a.save(guest);
            }
            if (guest.getAuthType() == 7) {
                this.j.deleteAuthingDataByClientMacAndSite(guest.getClientMac(), guest.getSite());
            }
            return com.tp_link.eap.util.e.bd;
        }
        return new OperationResponse(ResErrorCode.cQ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse extendAuth(String id) {
        Object object;
        if (id == null) {
            this.p.debug("Portal Extend Authorization id == null");
            return com.tp_link.eap.util.e.aZ;
        }
        Guest guest = (Guest)this.a.findOne((Serializable)((Object)id));
        if (guest == null) {
            this.p.debug("Portal Extend Authorization can not found Guest with id :" + id);
            return new OperationResponse(ResErrorCode.eb);
        }
        Query query = new Query();
        Long l2 = guest.getEnd() + this.r;
        if (!guest.getIsValid().booleanValue()) {
            query.addCriteria(Criteria.where((String)"site").is((Object)guest.getSite()));
            query.addCriteria(Criteria.where((String)"clientMac").is((Object)guest.getClientMac()));
            query.addCriteria(Criteria.where((String)"ssidId").is((Object)guest.getSsidId()));
            query.addCriteria(Criteria.where((String)"apMac").is((Object)guest.getApMac()));
            query.addCriteria(Criteria.where((String)"ssidName").is((Object)guest.getSsidName()));
            query.addCriteria(Criteria.where((String)"isValid").is((Object)true));
            if (this.d.exists(query, Guest.class)) {
                this.p.debug("Portal Extend Authorization Already Existed a Valid Guest Info :" + id);
                return new OperationResponse(ResErrorCode.ec);
            }
            l2 = System.currentTimeMillis() / 1000L + this.r;
        }
        query = new Query();
        query.addCriteria(Criteria.where((String)"_id").is((Object)id));
        Update update = new Update();
        update.set("isValid", (Object)true);
        update.set("end", (Object)l2);
        Object object2 = object = com.tp_link.eap.b.b.a.g((String)"guestglobal");
        synchronized (object2) {
            guest = (Guest)this.d.findAndModify(query, update, Guest.class);
            if (guest == null) {
                this.p.debug("Portal Extend Authorization Mongo Update Fail " + id);
                return new OperationResponse(ResErrorCode.ed);
            }
            ArrayList<Guest> arrayList = new ArrayList<Guest>();
            arrayList.add((Guest)this.a.findOne((Serializable)((Object)id)));
            this.sendAuthInfo(arrayList, null);
            return new OperationResponse(ResErrorCode.a, "Extend Guest Success.", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void authAging() {
        Object object;
        Long l2 = System.currentTimeMillis() / 1000L;
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"isValid").is((Object)true));
        query.addCriteria(Criteria.where((String)"end").lte((Object)l2));
        Update update = new Update();
        update.set("isValid", (Object)false);
        Object object2 = object = com.tp_link.eap.b.b.a.g((String)"guestglobal");
        synchronized (object2) {
            this.d.updateMulti(query, update, Guest.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeGuest(List<Guest> guests, String apMac) {
        Object object;
        if (guests == null) {
            this.p.debug("mergeAuth Param : null guest list");
            return;
        }
        Update update = new Update();
        update.set("isValid", (Object)false);
        Object object2 = object = com.tp_link.eap.b.b.a.g((String)"guestglobal");
        synchronized (object2) {
            for (Guest guest : guests) {
                Ssid ssid = this.k.findByName(guest.getSsidName());
                if (ssid == null) {
                    return;
                }
                PortalSetting portalSetting = this.f.getPortalSetting(ssid.getPortalId());
                if (portalSetting == null) {
                    return;
                }
                Integer n2 = com.tp_link.eap.a.b.a((String)portalSetting.getAuthType());
                if (n2 == 3 || n2 == 4) continue;
                guest.setAuthType(n2);
                Query query = new Query();
                query.addCriteria(Criteria.where((String)"site").is((Object)guest.getSite()));
                query.addCriteria(Criteria.where((String)"clientMac").is((Object)guest.getClientMac()));
                query.addCriteria(Criteria.where((String)"ssidId").is((Object)guest.getSsidId()));
                query.addCriteria(Criteria.where((String)"isValid").is((Object)true));
                query.addCriteria(Criteria.where((String)"apMac").is((Object)guest.getApMac()));
                query.addCriteria(Criteria.where((String)"ssidName").is((Object)guest.getSsidName()));
                query.addCriteria(Criteria.where((String)"end").gt((Object)guest.getEnd()));
                Long l2 = this.d.count(query, Guest.class);
                if (l2 > 0L) {
                    guest.setIsValid(Boolean.valueOf(false));
                } else {
                    guest.setIsValid(Boolean.valueOf(true));
                    query = new Query();
                    query.addCriteria(Criteria.where((String)"site").is((Object)guest.getSite()));
                    query.addCriteria(Criteria.where((String)"clientMac").is((Object)guest.getClientMac()));
                    query.addCriteria(Criteria.where((String)"ssidId").is((Object)guest.getSsidId()));
                    query.addCriteria(Criteria.where((String)"isValid").is((Object)true));
                    query.addCriteria(Criteria.where((String)"apMac").is((Object)guest.getApMac()));
                    query.addCriteria(Criteria.where((String)"ssidName").is((Object)guest.getSsidName()));
                    this.d.updateFirst(query, update, Guest.class);
                }
                this.p.debug("merge guest, save " + guest);
                this.a.save(guest);
            }
        }
    }

    @Override
    public void mergeAuth(List<AuthedUser> authedUsers, String apMac) {
        if (authedUsers == null) {
            this.p.debug("Merge Auth AuthedUser is null.");
            return;
        }
        List<Guest> list = this.a(authedUsers, apMac);
        this.mergeGuest(list, apMac);
    }

    private boolean a(Guest guest) {
        if (guest == null) {
            return false;
        }
        if (this.h.getStatGuestByGuestId(guest.getId()) != null) {
            return false;
        }
        StatCurrentGuest statCurrentGuest = new StatCurrentGuest();
        statCurrentGuest.setGuestid(guest.getId());
        statCurrentGuest.setClientMac(guest.getClientMac());
        statCurrentGuest.setApMac(guest.getApMac());
        statCurrentGuest.setRadioId(guest.getRadioId());
        statCurrentGuest.setSsidId(guest.getSsidId());
        statCurrentGuest.setSsidName(guest.getSsidName());
        statCurrentGuest.setAuthType(guest.getAuthType());
        statCurrentGuest.setSite(guest.getSite());
        statCurrentGuest.setWlanId(guest.getWlanId());
        statCurrentGuest.setStart(guest.getStart());
        statCurrentGuest.setEnd(guest.getEnd());
        if (guest.getVoucher() != null) {
            statCurrentGuest.setVoucherCode(guest.getVoucher().getCode());
        }
        if (guest.getLocalUser() != null) {
            statCurrentGuest.setLocalUserId(guest.getLocalUser().getId());
        }
        if (guest.getSmsToken() != null) {
            statCurrentGuest.setPhoneNumber(guest.getSmsToken().getPhoneNumber());
        }
        statCurrentGuest.setDownload(Long.valueOf(0L));
        statCurrentGuest.setUpload(Long.valueOf(0L));
        statCurrentGuest.setDuration(Long.valueOf(0L));
        return this.h.refreshCurrentGuestStat(statCurrentGuest);
    }

    @Override
    public List<Guest> getValidGuestsByVoucherCode(String voucherCode) {
        if (voucherCode == null) {
            this.p.debug("getValidGuestsByVoucherCode voucher code is null.");
            return null;
        }
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"voucherCode").is((Object)voucherCode));
        query.addCriteria(Criteria.where((String)"isValid").is((Object)true));
        List list = this.d.find(query, Guest.class);
        return list;
    }

    @Override
    public List<Guest> getGuestsByLocalUserId(String localUserId) {
        if (localUserId == null) {
            this.p.debug("getGuestsByLocalUserId localUserId is null.");
            return null;
        }
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"localUserId").is((Object)localUserId));
        List list = this.d.find(query, Guest.class);
        return list;
    }

    @Override
    public List<Guest> getValidGuestsByLocalUserId(String localUserId) {
        if (localUserId == null) {
            this.p.debug("getGuestsByLocalUserId localUserId is null.");
            return null;
        }
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"localUserId").is((Object)localUserId));
        query.addCriteria(Criteria.where((String)"isValid").is((Object)true));
        List list = this.d.find(query, Guest.class);
        return list;
    }

    @Override
    public List<Guest> getValidGuestsByPhoneNumber(String phoneNumber) {
        if (phoneNumber == null) {
            this.p.debug("getValidGuestsByPhoneNumber phoneNumber is null.");
            return null;
        }
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"phoneNumber").is((Object)phoneNumber));
        query.addCriteria(Criteria.where((String)"isValid").is((Object)true));
        List list = this.d.find(query, Guest.class);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse kickOutHotspotGuest(String guestId) {
        Object object;
        if (guestId == null) {
            this.p.debug("GuestService kickOutHotspotGuest guestId is null");
            return com.tp_link.eap.util.e.aZ;
        }
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"_id").is((Object)guestId));
        Update update = new Update();
        update.set("isValid", (Object)false);
        Object object2 = object = com.tp_link.eap.b.b.a.g((String)"guestglobal");
        synchronized (object2) {
            Guest guest = (Guest)this.d.findAndModify(query, update, Guest.class);
            if (guest == null) {
                this.p.debug("GuestService kickOutHotspotGuest fail.");
                return com.tp_link.eap.util.e.aZ;
            }
            this.p.debug("GuestService kickOutHotspotGuest success.");
            return com.tp_link.eap.util.e.bd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult delAllGuestBySsid(String ssidName, String wlanId, Integer radioId) {
        Object object;
        if (ssidName == null || radioId == null) {
            this.p.debug("delAllGuestBySsid params error.");
            return com.tp_link.eap.util.e.aX;
        }
        Ssid ssid = this.g.getSsidByName(ssidName, wlanId, radioId);
        if (ssid == null) {
            this.p.debug("delAllGuestBySsid ssid not found.");
            return new OperationResult(false, "delAllGuestBySsid ssid not found.");
        }
        Integer n2 = ssid.getIdInt();
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"ssidId").is((Object)n2));
        Object object2 = object = com.tp_link.eap.b.b.a.g((String)"guestglobal");
        synchronized (object2) {
            this.p.debug("delAllGuestBySsid ssidName:" + ssidName + " radioId:" + radioId + " ssidId:" + n2);
            this.d.remove(query, Guest.class);
        }
        return com.tp_link.eap.util.e.bc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult delAllGuestByAp(String apMac) {
        Object object;
        if (apMac == null) {
            this.p.debug("delAllGuestByAp apMac is null.");
            return com.tp_link.eap.util.e.aX;
        }
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"apMac").is((Object)apMac));
        Object object2 = object = com.tp_link.eap.b.b.a.g((String)"guestglobal");
        synchronized (object2) {
            this.p.debug("delAllGuestByAp apMac:" + apMac);
            this.d.remove(query, Guest.class);
        }
        return com.tp_link.eap.util.e.bc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult delAllGuestByOverrideSsid(String apMac, Integer ssidId) {
        Object object;
        if (apMac == null || ssidId == null) {
            this.p.debug("delAllGuestByOverrideSsid params error");
            return com.tp_link.eap.util.e.aX;
        }
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"apMac").is((Object)apMac));
        query.addCriteria(Criteria.where((String)"ssidId").is((Object)ssidId));
        Object object2 = object = com.tp_link.eap.b.b.a.g((String)"guestglobal");
        synchronized (object2) {
            this.p.debug("delAllGuestByOverrideSsid apMac:" + apMac + " ssidId:" + ssidId);
            this.d.remove(query, Guest.class);
        }
        return com.tp_link.eap.util.e.bc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse delGuestById(String guestId) {
        Object object;
        if (guestId == null) {
            this.p.debug("Delete Guest id == null");
            return com.tp_link.eap.util.e.aZ;
        }
        Object object2 = object = com.tp_link.eap.b.b.a.g((String)"guestglobal");
        synchronized (object2) {
            Guest guest = (Guest)this.a.findOne((Serializable)((Object)guestId));
            if (guest == null) {
                this.p.debug("Delete Guest can not found Guest with id :" + guestId);
                return new OperationResponse(ResErrorCode.ei);
            }
            this.a.delete(guest);
        }
        object2 = this.h.getStatGuestByGuestId(guestId);
        if (object2 != null) {
            this.h.removeCurrentGuestStat((StatCurrentGuest)object2);
        }
        return new OperationResponse(ResErrorCode.a, "Delete Guest successfully.", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanGuests() {
        Object object;
        Long l2 = System.currentTimeMillis() / 1000L;
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"isValid").is((Object)false));
        query.addCriteria(Criteria.where((String)"end").lt((Object)(l2 - 2L * s)));
        Object object2 = object = com.tp_link.eap.b.b.a.g((String)"guestglobal");
        synchronized (object2) {
            this.d.remove(query, Guest.class);
        }
    }

    @Override
    public void refreshGuest(Map<String, Guest> guests) {
        Guest guest;
        Object object;
        List<StatCurrentGuest> list = this.h.getAll();
        this.p.debug("refresh guests, cache guest size: " + guests.size());
        if (!CollectionUtils.isEmpty(list)) {
            this.p.debug("refresh guests, currentStatGuest size: " + list.size());
            for (int i2 = 0; i2 < list.size(); ++i2) {
                String string;
                Ap ap;
                StatCurrentGuest statCurrentGuest = list.get(i2);
                object = statCurrentGuest.getSite() + statCurrentGuest.getClientMac() + statCurrentGuest.getSsidName() + statCurrentGuest.getRadioId();
                guest = guests.get(object);
                if (guest == null || (ap = this.e.getWlanGroupIdByMac(guest.getApMac())) == null) continue;
                String string2 = string = guest.getRadioId() == 0 ? ap.getWlanGroupId2G() : ap.getWlanGroupId5G();
                if (statCurrentGuest.getWlanId() == null || !statCurrentGuest.getWlanId().equals(string)) continue;
                Guest guest2 = (Guest)this.a.findOne((Serializable)((Object)statCurrentGuest.getGuestid()));
                this.p.debug("find the Guest, " + guest2);
                if (guest2 == null) continue;
                if (!Boolean.TRUE.equals(guest2.getIsValid())) {
                    this.p.debug("statCurrentGuest is useless, merge and delete.");
                    guest2.setUpload(Long.valueOf(guest2.getUpload() + statCurrentGuest.getUpload()));
                    guest2.setDownload(Long.valueOf(guest2.getDownload() + statCurrentGuest.getDownload()));
                    guest2.setDuration(Long.valueOf(guest2.getDuration() + statCurrentGuest.getDuration()));
                    guest2.setDownloadTotal(guest2.getDownload());
                    guest2.setUploadTotal(guest2.getUpload());
                    this.a.save(guest2);
                    this.h.removeCurrentGuestStat(statCurrentGuest);
                    list.remove(i2);
                    guests.remove(object);
                    --i2;
                    continue;
                }
                if (statCurrentGuest.getUpload() + statCurrentGuest.getDownload() > guest.getUpload() + guest.getDownload() && statCurrentGuest.getDuration() > guest.getDuration() && guest2 != null) {
                    guest2.setUpload(Long.valueOf(guest2.getUpload() + statCurrentGuest.getUpload()));
                    guest2.setDownload(Long.valueOf(guest2.getDownload() + statCurrentGuest.getDownload()));
                    guest2.setDuration(Long.valueOf(guest2.getDuration() + statCurrentGuest.getDuration()));
                }
                statCurrentGuest.setUpload(guest.getUpload());
                statCurrentGuest.setDownload(guest.getDownload());
                statCurrentGuest.setDuration(guest.getDuration());
                this.h.refreshCurrentGuestStat(statCurrentGuest);
                if (guest2 != null) {
                    guest2.setUploadTotal(Long.valueOf(guest2.getUpload() + guest.getUpload()));
                    guest2.setDownloadTotal(Long.valueOf(guest2.getDownload() + guest.getDownload()));
                    this.b(guest2);
                    this.a.save(guest2);
                }
                this.p.debug("refresh statCurrentGuest successfully, " + statCurrentGuest);
                list.remove(i2);
                guests.remove(object);
                --i2;
            }
        }
        if (!CollectionUtils.isEmpty(list)) {
            this.p.debug("refreshGuests, remain statCurrentGuest size:" + list.size());
            for (StatCurrentGuest statCurrentGuest : list) {
                if (statCurrentGuest.getStart() != null && System.currentTimeMillis() / 1000L - statCurrentGuest.getStart() < 30L) continue;
                object = (Guest)this.a.findOne((Serializable)((Object)statCurrentGuest.getGuestid()));
                if (object != null) {
                    object.setUpload(Long.valueOf(object.getUpload() + statCurrentGuest.getUpload()));
                    object.setDownload(Long.valueOf(object.getDownload() + statCurrentGuest.getDownload()));
                    object.setDuration(Long.valueOf(object.getDuration() + statCurrentGuest.getDuration()));
                    object.setUploadTotal(object.getUpload());
                    object.setDownloadTotal(object.getDownload());
                    this.a.save(object);
                }
                this.h.removeCurrentGuestStat(statCurrentGuest);
            }
        }
        if (!CollectionUtils.isEmpty(guests)) {
            this.p.debug("Remain cacheGuest size: " + guests.size());
            for (Guest guest3 : guests.values()) {
                com.tp_link.eap.d.b.f((String)guest3.getApMac());
                object = this.getAuthInfoByRadioId(guest3.getSite(), guest3.getClientMac(), guest3.getRadioId(), guest3.getSsidName(), guest3.getApMac());
                this.p.debug("find guest: " + object);
                if (object == null || !Boolean.TRUE.equals(object.getIsValid())) continue;
                guest = new StatCurrentGuest();
                guest.setGuestid(object.getId());
                guest.setClientMac(object.getClientMac());
                guest.setApMac(object.getApMac());
                guest.setRadioId(object.getRadioId());
                guest.setSsidId(object.getSsidId());
                guest.setSsidName(object.getSsidName());
                guest.setAuthType(object.getAuthType());
                guest.setVoucherCode(object.getVoucherCode());
                guest.setLocalUserId(object.getLocalUserId());
                guest.setSite(object.getSite());
                guest.setWlanId(object.getWlanId());
                guest.setStart(object.getStart());
                guest.setEnd(object.getEnd());
                guest.setDownload(guest3.getDownload());
                guest.setUpload(guest3.getUpload());
                guest.setDuration(guest3.getDuration());
                this.h.refreshCurrentGuestStat((StatCurrentGuest)guest);
                object.setDownloadTotal(Long.valueOf(object.getDownload() + guest.getDownload()));
                object.setUploadTotal(Long.valueOf(object.getUpload() + guest.getUpload()));
                this.a.save(object);
                this.p.debug("guestservice, store remain cache guest :" + guest);
            }
        }
    }

    private void b(Guest guest) {
        if (guest != null) {
            if (guest.getAuthType() == 3) {
                if (guest.getVoucher() != null && guest.getVoucher().getByteQuotaEnable().booleanValue()) {
                    long l2 = guest.getVoucher().getByteQuota();
                    this.a(guest, l2);
                }
            } else if (guest.getAuthType() == 5 && guest.getLocalUser() != null && guest.getLocalUser().getQuotaEnable()) {
                long l3 = guest.getLocalUser().getQuotaLimit();
                this.a(guest, l3);
            }
        }
    }

    private void a(Guest guest, long l2) {
        if (guest.getUploadTotal() + guest.getDownloadTotal() > l2 * 0x100000L) {
            this.c(guest);
        }
    }

    private void a(Voucher voucher) {
        List<Guest> list = this.a.findByVoucher(voucher);
        this.a(list);
    }

    private void c(Guest guest) {
        List<Guest> list = Collections.singletonList(guest);
        this.a(list);
    }

    private void a(LocalUser localUser) {
        localUser.setQuotaLeft(false);
        this.b.save(localUser);
        List<Guest> list = this.a.findByLocalUserId(localUser.getId());
        this.a(list);
    }

    private void a(List<Guest> list) {
        for (Guest guest : list) {
            com.tp_link.eap.d.b.b((String)guest.getSite());
            Client client = this.d(guest);
            String string = client.getId();
            String string2 = guest.getSite();
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            executorService.execute(new a(this, string2, string));
        }
    }

    private Client d(Guest guest) {
        String string = guest.getClientMac().toUpperCase(Locale.ROOT).replace(":", "-");
        String string2 = guest.getSite();
        return this.i.getClient(string, string2);
    }

    @Override
    public void sendAuthInfo(List<Guest> guests, String apMac) {
        AuthorizationBody authorizationBody = this.b(guests);
        if (authorizationBody == null) {
            return;
        }
        if (apMac != null) {
            com.tp_link.eap.monitor.a.a.a(EventType.EVENT_PORTAL_AUTH, AuthorizationBody.class, authorizationBody, apMac);
        } else {
            String string = apMac == null ? com.tp_link.eap.d.b.a() : com.tp_link.eap.d.b.e((String)apMac);
            List<Ap> list = this.e.getSiteConnectedAps(string);
            if (!CollectionUtils.isEmpty(list)) {
                for (Ap ap : list) {
                    String string2 = ap.getMac();
                    o.execute(new com.tp_link.eap.monitor.portal.service.impl.b(this, authorizationBody, string2));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteBySite() {
        Object object;
        String string = com.tp_link.eap.d.b.a();
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"site").is((Object)string));
        Object object2 = object = com.tp_link.eap.b.b.a.g((String)"guestglobal");
        synchronized (object2) {
            this.d.remove(query, Guest.class);
        }
    }

    private AuthorizationBody b(List<Guest> list) {
        if (list == null) {
            return null;
        }
        ArrayList<AuthedUser> arrayList = new ArrayList<AuthedUser>();
        for (Guest guest : list) {
            AuthedUser authedUser = new AuthedUser();
            authedUser.setAuthedResult(Integer.valueOf(1));
            authedUser.setClientMac(guest.getClientMac());
            authedUser.setSsid(guest.getSsidName());
            authedUser.setRadioId(guest.getRadioId());
            authedUser.setStartTime(guest.getStart());
            authedUser.setEndTime(guest.getEnd());
            this.setGuestLimitConfigToAuthedUser(authedUser, guest);
            arrayList.add(authedUser);
        }
        AuthorizationBody authorizationBody = new AuthorizationBody();
        authorizationBody.setAuthedUsers(arrayList);
        return authorizationBody;
    }

    @Override
    public void setGuestLimitConfigToAuthedUser(AuthedUser u, Guest g2) {
        if (g2.getVoucher() != null) {
            if (g2.getVoucher().getUpLimitEnable().booleanValue()) {
                u.setUpLimit(g2.getVoucher().getUpLimit());
            } else {
                u.setUpLimit(Long.valueOf(0L));
            }
            if (g2.getVoucher().getDownLimitEnable().booleanValue()) {
                u.setDownLimit(g2.getVoucher().getDownLimit());
            } else {
                u.setDownLimit(Long.valueOf(0L));
            }
            if (g2.getVoucher().getByteQuotaEnable().booleanValue()) {
                u.setDataUsageLimit(g2.getVoucher().getByteQuota());
            } else {
                u.setDataUsageLimit(Long.valueOf(0L));
            }
        } else if (g2.getLocalUser() != null) {
            LocalUser localUser = g2.getLocalUser();
            if (localUser.getUploadEnable()) {
                u.setUpLimit(localUser.getUploadLimit());
            } else {
                u.setUpLimit(Long.valueOf(0L));
            }
            if (localUser.getDownloadEnable()) {
                u.setDownLimit(localUser.getDownloadLimit());
            } else {
                u.setDownLimit(Long.valueOf(0L));
            }
            if (localUser.getQuotaEnable()) {
                u.setDataUsageLimit(localUser.getQuotaLimit());
            } else {
                u.setDataUsageLimit(Long.valueOf(0L));
            }
        } else {
            u.setUpLimit(Long.valueOf(0L));
            u.setDownLimit(Long.valueOf(0L));
            u.setDataUsageLimit(Long.valueOf(0L));
        }
    }

    private Integer a(boolean bl, String string, Integer n2, String string2) {
        Ap ap = this.e.getApDetail(string2);
        if (ap == null) {
            this.p.debug("Qeury Info Error: no Ap existed with MAC:" + string2);
            return -1;
        }
        String string3 = null;
        string3 = n2 == 0 ? ap.getWlanGroupId2G() : ap.getWlanGroupId5G();
        if (bl) {
            List list = null;
            list = n2 == 0 ? ap.getSsidOverrides() : ap.getSsidOverrides5g();
            if (list == null) {
                return 0;
            }
            for (SsidOverride ssidOverride : list) {
                if (!string.equals(ssidOverride.getSsid())) continue;
                Ssid ssid = this.g.getSsidByName(ssidOverride.getGlobalSsid(), string3, n2);
                if (ssid == null) {
                    return -1;
                }
                return ssid.getIdInt();
            }
            return 0;
        }
        Ssid ssid = this.g.getSsidByName(string, string3, n2);
        if (ssid == null) {
            return -1;
        }
        return ssid.getIdInt();
    }

    private List<Guest> a(List<AuthedUser> list, String string) {
        if (list == null) {
            return null;
        }
        String string2 = com.tp_link.eap.d.b.e((String)string);
        Ap ap = this.e.getWlanGroupIdByMac(string);
        if (string2 == null || ap == null) {
            return null;
        }
        ArrayList<Guest> arrayList = new ArrayList<Guest>();
        for (AuthedUser authedUser : list) {
            Guest guest = this.a(authedUser, string, string2, ap);
            if (guest == null) continue;
            arrayList.add(guest);
        }
        return arrayList;
    }

    private Guest a(AuthedUser authedUser, String string, String string2, Ap ap) {
        Guest guest = new Guest();
        boolean bl = false;
        Integer n2 = this.a(false, authedUser.getSsid(), authedUser.getRadioId(), string);
        if (n2 <= 0) {
            bl = true;
            n2 = this.a(true, authedUser.getSsid(), authedUser.getRadioId(), string);
        }
        if (n2 <= 0) {
            return null;
        }
        if (bl) {
            Guest guest2 = this.a(string2, authedUser.getClientMac(), n2, authedUser.getSsid(), string);
            if (guest2 != null) {
                return null;
            }
            guest.setApMac(string);
        } else {
            Guest guest3 = this.a(string2, authedUser.getClientMac(), n2, authedUser.getSsid(), null);
            if (guest3 != null) {
                return null;
            }
            guest.setApMac(null);
        }
        guest.setSsidId(n2);
        guest.setClientMac(authedUser.getClientMac());
        guest.setSsidName(authedUser.getSsid());
        guest.setStart(authedUser.getStartTime());
        guest.setEnd(authedUser.getEndTime());
        guest.setRadioId(authedUser.getRadioId());
        if (authedUser.getRadioId() == 0) {
            guest.setWlanId(ap.getWlanGroupId2G());
            guest.setWlanName(ap.getWlan2g());
        } else {
            guest.setWlanId(ap.getWlanGroupId5G());
            guest.setWlanName(ap.getWlan5g());
        }
        guest.setIsValid(Boolean.valueOf(true));
        guest.setSite(string2);
        return guest;
    }

    public List<Guest> getList(QueryPage queryPage) {
        List<Guest> list = this.getList(queryPage, null, null, null);
        if (null == list || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List<Guest> getList(QueryPage queryPage, QuerySort querySort) {
        List<Guest> list = this.getList(queryPage, querySort, null, null);
        if (null == list || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List<Guest> getList(QueryPage queryPage, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        List<Guest> list = this.getList(queryPage, null, filters, searchFilters);
        if (null == list || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List<Guest> getList(QueryPage queryPage, QuerySort querySort, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        List<Guest> list = this.a.getByFilters(queryPage, querySort, filters, searchFilters);
        if (null == list || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public long count(List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.a.getByFilters(null, null, filters, searchFilters).size();
    }

    @Override
    public OperationResponse getGridGuestList(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.p.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        QueryData queryData = (QueryData)com.tp_link.eap.util.a.b.a((Object)jSONObject, QueryData.class);
        String string = queryData.getSortName();
        if (com.tp_link.eap.util.a.e.a((String)queryData.getSortName())) {
            queryData.setSortName("start");
            queryData.setSortOrder("desc");
        }
        if ("authType".equals(queryData.getSortName())) {
            queryData.setSortName(queryData.getSortName() + ",voucherCode,_id");
        } else {
            queryData.setSortName(queryData.getSortName() + ",_id");
        }
        Grid grid = new Grid(queryData);
        grid.initSearch(queryData.getSearchKey(), new String[]{"clientMac", "ssidName"});
        Map map = queryData.getFilters();
        Object v = map.get("startTime");
        if (v != null) {
            Long l2 = Long.parseLong(String.valueOf(v));
            Long l3 = 0L;
            l3 = l2 == 0L ? Long.valueOf(0L) : Long.valueOf(System.currentTimeMillis() / 1000L - l2 * 3600L);
            grid.initFilters("start", (Object)l3, QueryFilter.FilterType.gte);
        }
        long l4 = this.count(grid);
        grid.setTotalRows(l4);
        List list = this.getList(grid);
        if (null == list || list.isEmpty()) {
            queryData.setSortName(string);
            return new OperationResponse(ResErrorCode.a, (Object)grid);
        }
        queryData.setSortName(string);
        grid.setData(list);
        return new OperationResponse(ResErrorCode.a, (Object)grid);
    }

    @Override
    public OperationResponse getGridHotSpotGuests(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.p.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        QueryData queryData = (QueryData)JSONObject.toBean((JSONObject)jSONObject, QueryData.class);
        String string = queryData.getSortName();
        if (com.tp_link.eap.util.a.e.a((String)queryData.getSortName())) {
            queryData.setSortName("start");
            queryData.setSortOrder("desc");
        }
        if ("authType".equals(queryData.getSortName())) {
            queryData.setSortName(queryData.getSortName() + ",voucherCode,_id");
        } else {
            queryData.setSortName(queryData.getSortName() + ",_id");
        }
        Grid grid = new Grid(queryData);
        grid.initSearch(queryData.getSearchKey(), new String[]{"clientMac", "ssidName"});
        Map map = queryData.getFilters();
        Object v = map.get("startTime");
        if (v != null) {
            Long l2 = Long.parseLong((String)v);
            Long l3 = 0L;
            l3 = l2 == 0L ? Long.valueOf(0L) : Long.valueOf(System.currentTimeMillis() / 1000L - l2 * 3600L);
            grid.initFilters("start", (Object)l3, QueryFilter.FilterType.gte);
        }
        long l4 = this.count(grid);
        grid.setTotalRows(l4);
        List list = this.getList(grid);
        if (null == list || list.isEmpty()) {
            queryData.setSortName(string);
            return new OperationResponse(ResErrorCode.a, (Object)grid);
        }
        queryData.setSortName(string);
        grid.setData(list);
        return new OperationResponse(ResErrorCode.a, (Object)grid);
    }

    @Override
    public OperationResponse extendAuthDuration(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.p.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("guestId", null);
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return com.tp_link.eap.util.e.aZ;
        }
        OperationResponse operationResponse = this.extendAuth(string);
        if (operationResponse.success()) {
            Guest guest = this.findById(string);
            String string2 = null;
            String string3 = null;
            if (controlType.equals((Object)ControlType.c) || controlType.equals((Object)ControlType.a)) {
                string2 = SecurityUtils.getSubject().hasRole("administrator") ? "Admin" : "Operator";
                string3 = (String)SecurityUtils.getSubject().getPrincipal();
            } else {
                String string4 = com.tp_link.eap.monitor.cloud.e.a.a(reqObj);
                if (com.tp_link.eap.util.a.e.a((String)string4)) {
                    this.p.warn("Failed to find accountId for cloud extendAuthDuration");
                    return com.tp_link.eap.util.e.aY;
                }
                CloudUser cloudUser = this.l.getCloudUserByAccountId(string4);
                if (cloudUser == null) {
                    return new OperationResponse(ResErrorCode.ct);
                }
                string3 = cloudUser.getAccountName();
                string2 = cloudUser.getRole().getName().equals("administrator") ? "Admin" : "Operator";
            }
            q.b("GT", "Extend", String.format("Guest[%s] was extended by %s[%s]", guest.getClientMac(), string2, string3));
        }
        return operationResponse;
    }

    @Override
    public OperationResponse deleteGuest(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.p.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("guestId", null);
        return this.delGuestById(string);
    }

    @Override
    public List<Guest> getAuthInfoAfterTime(long time) {
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"end").gt((Object)time));
        return this.d.find(query, Guest.class);
    }

    @Override
    public void addGuests(List<Guest> guestList) {
        this.a.save(guestList);
    }

    static /* synthetic */ com.tp_link.eap.monitor.monitor.service.d a(GuestService guestService) {
        return guestService.i;
    }

    static /* synthetic */ Logger b(GuestService guestService) {
        return guestService.p;
    }
}

